<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Chat extends Model 
{

    protected $table = 'chats';
    public $timestamps = true;
    protected $fillable = array('user_id', 'second_user_id', 'photo', 'name', 'file', 'voice', 'message', 'latitude', 'longitude', 'order_id');

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function secondUser()
    {
        return $this->belongsTo('App\User', 'second_user_id');
    }

    public function order()
    {
        return $this->belongsTo('App\Models\Order', 'order_id');
    }

}